import os
import openai
import random
import numpy as np
import json
import jsonlines
import time
import re
from tqdm import tqdm
from rank_bm25 import BM25Okapi

# OPENAI_API_KEY = "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"
OPENAI_API_KEY = "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"
openai.api_key = OPENAI_API_KEY


def ask_gpt4(question):
    messages=[{"role": "user", "content": question}]
    while True:
        try:
            response =  openai.ChatCompletion.create(
                            model="gpt-4",
                            max_tokens=1000,
                            temperature=1.2,
                            messages = messages)
            answer = response["choices"][0]["message"]["content"]
            return answer
        except openai.error.RateLimitError: # Rate limit exceeded
            time.sleep(0.2)
        except openai.error.Timeout: # Rate limit exceeded
            time.sleep(0.2)
        except openai.error.OpenAIError:
            raise Exception("Sorry, a problem happened")


if __name__ == "__main__":
    dataset = jsonlines.open('./gpt4_ans/whoops/cb_icl/test.jsonl', mode='r') 
    gpt4_scores = 0.0
    count = 0
    with tqdm(desc='Process', unit='it', total=51) as pbar: 
        with open('./ans2res/whoops/cb_icl/test.jsonl', 'w') as outfile:
            for line in dataset.iter():
                designer_explanation = line["designer_explanation"]
                chatgpt_explanation = line["gpt4"]
                Question_part1 = '''"What is unusual in this image?" Answer with True or False. The sentence A: %s; The sentence B: %s. True if the sentence A and the sentence B have the same meaning, False if they do not''' %(designer_explanation,chatgpt_explanation)
                Question_part2 = '''Directly return True or False as answer.'''
                content = f'''{Question_part1}{Question_part2}'''
                answer = ask_gpt4(content)
                line['gpt4_rate'] = answer
                if re.search(re.escape('True'.lower()), answer.lower(), re.I): 
                    gpt4_score = 1
                else:
                    gpt4_score = 0
                gpt4_scores += gpt4_score
                pbar.set_postfix(gpt4_scores=gpt4_scores / (count + 1))
                count = count + 1
                json.dump(line, outfile)
                outfile.write('\n')
                pbar.update()
                













